﻿
a4["initChart"] = function (container, chartData, chartType) {
    var getXAxisConfig = function (chartData) {
        var axis = chartData.xAxis;
       
        if (!axis) {
            axis = {
                allowDecimals: false,
                categories: [],
                labels: {
                    align: chartData.type == "bar" ? 'right':'center',
                    style: {
                        fontSize: '13px',
                        fontFamily: 'Verdana, sans-serif',
                        width: '100px'
                    }
                },
                title: { align: 'high' },
                labels: {
                    formatter: function () {
                        return chartData.series[0].data[this.value].name;
                    }
                },
            }
        }
        return axis;
    };

    var getTooltipFormatter = function () {
        return function () {
            if (getChartType() == "bar" && this.point.name == undefined)
                return this.series.name + ' : ' + this.y;
            else
                return this.point.name + ' (' + this.y+')';
        };
    };

    var getChartType = function () {
        if (chartType)
            return chartType;
        else
            return chartData.type;
    };

    if (chartData.series.length == 1) {
        chartData.series[0].dataLabels = {
            enabled: true,
            color: '#000000',
            align: 'center',
            x: chartData.type == "bar" ? 10 : 0,
            y: 0,
            style: {
                fontSize: '13px',
                fontFamily: 'Verdana, sans-serif'
            }
        };
    }

    $(container).highcharts({
        chart: {
            type: getChartType(),
            plotBackgroundColor: null,
            plotBorderWidth: null,
            plotShadow: false,
            events: {
                load: function () {
                    var selectedChartType = getChartType();

                    var $ts = $(".v-chartTypeSelector", $(this.container).parents(".v-chartControl"));
                    if ($ts.length > 0) {
                        $ts.show();
                        $("select", $ts).val(selectedChartType);
                    }

                    var chartHeight = this.chartHeight;

                    if (selectedChartType == "bar") {
                        var xAxis = this.xAxis[0];

                        if (xAxis) {
                            // Convert bar height from axis units to pixels
                            var barHeight = xAxis.toPixels(0.025);
                            // Multiply bar height with count and add whitespace between full chart and plot height
                            var calculatedHeight = barHeight * this.pointCount + (chartHeight - this.plotHeight);

                            if (calculatedHeight > chartHeight) {
                                chartHeight = calculatedHeight;
                            }
                        }
                    }

                    this.update({
                        chart: {
                            height: chartHeight
                        }
                    });
                }
            }
        },
        tooltip: {
            formatter: getTooltipFormatter()
        },
        title: {
            text: null
        },
        credits: {
            enabled: false
        },
        plotOptions: {
            pie: {
                allowPointSelect: true,
                cursor: 'pointer',
                dataLabels: {
                    enabled: true,
                    color: '#000000',
                    connectorColor: '#000000',
                    format: '<b>{point.name}:</b> <span style="font-size:16px; font-weight:bold">{point.y}</span> ({point.percentage:.1f}%)',
                    style: {
                        width: 250
                    }
                }
            },
            bar: {
                pointPadding: 0.2,
                groupPadding: 0.05,
                borderWidth: 0,
                colorByPoint: !(chartData.series.length > 1)
            },
            column: {
                pointPadding: 0.2,
                borderWidth: 0,
                colorByPoint: true
            },
            series: {
                animation: (typeof chartData.animation != 'undefined') ? chartData.animation : true
            }
        },
        xAxis: getXAxisConfig(chartData),
        yAxis: {
            allowDecimals: false,
            min: 0,
            title: {
                text: null
            }
        },
        legend: {
            enabled: (chartData.series.length > 1),
            layout: 'vertical',
            align: 'right',
            verticalAlign: 'top',
            x: 0,
            y: 0,
            floating: false,
            borderWidth: 1,
            backgroundColor: '#FFFFFF',
            shadow: true,
            reversed: false,
            symbolHeight: 10,
            symbolPadding: 5,
            symbolRadius: 6,
            symbolWidth: 10
            
        },
        series: chartData.series
    });
}; 
// Drop Outs/Other, Screen out, Interrupted, Completed 
var a4chartColors = ['#ffd700', '#2989b3', '#eb6725', '#95c757', '#13B368', '#CB4A3D', '#5E3C99', '#7AC843', '#6cace0', '#6befb2', '#c2e6a8', '#9b7ecd', '#e29992', '#E66101', '#feb580'];

$(document).ready(function () {
    Highcharts.getOptions().colors = Highcharts.map(a4chartColors, function (color) {
        return {
            radialGradient: { cx: 0.1, cy: 0.1, r: 0.1 },
            stops: [
                [0, color],
                [1, Highcharts.Color(color).brighten(0.0).get('rgb')] // dont alter color for now
            ]
        };
    });
}); 